#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.IO;

#endregion

namespace gov.va.med.vbecs.VAL.UnitTests
{
	/// <summary>
	/// Set of utilities used to test VistA RPCs
	/// </summary>
	public class RpcFunctionUnitTestUtility_VAL : BaseTest 
	{
		public static void SaveXmlToFile(string xmlFilePath, string xmlString)
		{
			using( StreamWriter sw = new StreamWriter(xmlFilePath) )
			{
				sw.Write(xmlString);
			}
		}

		public static DataSet LoadXmlStringIntoDataSet( string xmlString )
		{
			if( xmlString == null )
				throw( new ArgumentNullException( "xmlString" ) );

			DataSet _ds = new DataSet();
			_ds.ReadXml( new StringReader( xmlString ), XmlReadMode.InferSchema );

			return _ds;
		}

		public static bool DeleteXmlFile(string xmlFilePath)
		{
			FileInfo _fileInfo = new FileInfo(xmlFilePath);
			if( _fileInfo.Exists )
			{
				_fileInfo.Delete();
			}
			return _fileInfo.Exists;
				
		}
	}
}
#endif
